VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Begin VB.Form Form1 
   BackColor       =   &H00C0FFC0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "U3800 LAN DspTrace Ver. 1.1"
   ClientHeight    =   5040
   ClientLeft      =   1200
   ClientTop       =   1275
   ClientWidth     =   7725
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   9
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5040
   ScaleWidth      =   7725
   Begin VB.TextBox txtPortC 
      Height          =   285
      Left            =   2520
      TabIndex        =   26
      Text            =   "5025"
      Top             =   1440
      Width           =   615
   End
   Begin VB.TextBox txtHostC 
      Height          =   285
      Left            =   840
      TabIndex        =   25
      Text            =   "192.168.0.3"
      Top             =   1440
      Width           =   1575
   End
   Begin VB.TextBox txtPortB 
      Height          =   285
      Left            =   2520
      TabIndex        =   24
      Text            =   "5025"
      Top             =   1080
      Width           =   615
   End
   Begin VB.TextBox txtHostB 
      Height          =   285
      Left            =   840
      TabIndex        =   23
      Text            =   "192.168.0.2"
      Top             =   1080
      Width           =   1575
   End
   Begin VB.Frame Frame3 
      BackColor       =   &H00C0FFC0&
      BorderStyle     =   0  'None
      Caption         =   "Host"
      Height          =   1215
      Left            =   120
      TabIndex        =   18
      Top             =   600
      Width           =   615
      Begin VB.OptionButton Option7 
         BackColor       =   &H00C0FFC0&
         Caption         =   "C"
         Height          =   255
         Left            =   120
         TabIndex        =   22
         Top             =   840
         Width           =   495
      End
      Begin VB.OptionButton Option6 
         BackColor       =   &H00C0FFC0&
         Caption         =   "B"
         Height          =   255
         Left            =   120
         TabIndex        =   21
         Top             =   480
         Width           =   495
      End
      Begin VB.OptionButton Option5 
         BackColor       =   &H00C0FFC0&
         Caption         =   "A"
         Height          =   255
         Left            =   120
         TabIndex        =   20
         Top             =   120
         Value           =   -1  'True
         Width           =   495
      End
   End
   Begin VB.Frame Frame1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Select CH"
      ForeColor       =   &H00000000&
      Height          =   1215
      Left            =   3240
      TabIndex        =   15
      Top             =   600
      Width           =   1095
      Begin VB.OptionButton Option2 
         BackColor       =   &H00C0FFC0&
         Caption         =   "CH2"
         Height          =   255
         Left            =   240
         TabIndex        =   17
         Top             =   720
         Width           =   735
      End
      Begin VB.OptionButton Option1 
         BackColor       =   &H00C0FFC0&
         Caption         =   "CH1"
         Height          =   255
         Left            =   240
         TabIndex        =   16
         Top             =   360
         Value           =   -1  'True
         Width           =   735
      End
   End
   Begin VB.CheckBox chkMon 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Monitor"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6480
      TabIndex        =   12
      Top             =   4080
      Width           =   1035
   End
   Begin VB.CommandButton cmdEnd 
      BackColor       =   &H00C0C0FF&
      Caption         =   "EXIT"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   6120
      Style           =   1  'Graphical
      TabIndex        =   11
      ToolTipText     =   "Exit the program"
      Top             =   240
      Width           =   975
   End
   Begin VB.CommandButton cmdTrace 
      BackColor       =   &H0080FF80&
      Caption         =   "Waveform View"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   915
      Left            =   5760
      Style           =   1  'Graphical
      TabIndex        =   10
      ToolTipText     =   "Run FUS monitor"
      Top             =   720
      Width           =   1695
   End
   Begin VB.ListBox lstRecv 
      BeginProperty Font 
         Name            =   "lr oSVbN"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1500
      ItemData        =   "Form1.frx":0442
      Left            =   240
      List            =   "Form1.frx":0444
      TabIndex        =   7
      Top             =   2100
      Width           =   7215
   End
   Begin ComctlLib.StatusBar sbrMessage 
      Align           =   2  'Align Bottom
      Height          =   435
      Left            =   0
      TabIndex        =   6
      Top             =   4605
      Width           =   7725
      _ExtentX        =   13626
      _ExtentY        =   767
      Style           =   1
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdDisConn 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Close"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   4560
      Style           =   1  'Graphical
      TabIndex        =   5
      ToolTipText     =   "Disconnect with FUS"
      Top             =   1320
      Width           =   975
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "SendText"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   5280
      TabIndex        =   4
      ToolTipText     =   "Sending a command to FUS"
      Top             =   4080
      Width           =   1035
   End
   Begin VB.CommandButton cmdConnect 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Connect"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   4560
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   "Connect with FUS"
      Top             =   720
      Width           =   975
   End
   Begin VB.TextBox txtPortA 
      Height          =   285
      Left            =   2520
      TabIndex        =   2
      Text            =   "5025"
      Top             =   720
      Width           =   615
   End
   Begin VB.TextBox txtSend 
      Height          =   270
      Left            =   1560
      TabIndex        =   1
      Text            =   "*IDN?"
      Top             =   4080
      Width           =   3555
   End
   Begin VB.TextBox txtHostA 
      Height          =   285
      Left            =   840
      TabIndex        =   0
      Text            =   "192.168.0.1"
      Top             =   720
      Width           =   1575
   End
   Begin MSWinsockLib.Winsock tcpClient 
      Left            =   960
      Top             =   120
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Label Label4 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Host"
      Height          =   255
      Left            =   240
      TabIndex        =   19
      Top             =   360
      Width           =   495
   End
   Begin VB.Line Line2 
      BorderColor     =   &H80000002&
      X1              =   4320
      X2              =   7440
      Y1              =   3840
      Y2              =   3840
   End
   Begin VB.Line Line1 
      BorderColor     =   &H80000002&
      X1              =   240
      X2              =   2880
      Y1              =   3840
      Y2              =   3840
   End
   Begin VB.Label Label3 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Test Mode"
      Height          =   255
      Left            =   3240
      TabIndex        =   14
      Top             =   3720
      Width           =   975
   End
   Begin VB.Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "U3800 Waveform Viewer via LAN"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00808000&
      Height          =   315
      Left            =   1680
      TabIndex        =   13
      Top             =   60
      Width           =   3915
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Sending Text"
      Height          =   195
      Index           =   2
      Left            =   240
      TabIndex        =   9
      Top             =   4080
      Width           =   1095
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0FFC0&
      Caption         =   "Port No."
      Height          =   195
      Index           =   1
      Left            =   2520
      TabIndex        =   8
      Top             =   360
      Width           =   735
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'*--------------------------------------------------------------------------
'*.Program Name :        LAN Remote SPA Viewer
'*
'*      Sample software for Advantest Spectrum Analyzer U37xx
'*
'*.Description :
'*
'*.Revision History :
'*      1.00           1-JAN-2006       First Release. by Ogino
'*      2.00           1-JAN-2007       2nd   Release. by Hirakoso
'*      2.10           1-JUL-2007       2.1   Release. by Hirakoso
'*
'*      2.20           1-JAN-2010       2.2   Release. by Hirakoso
'*                                            Add the Invert Display
'*
'*      U3800 V10      7-DEC-2011       1.0   Release for U3800 by Hirakoso
'*
'*      U3800 V11      5-JUL-2011       1.1   Change the Dir. for Init_File
'*                                            EDIT by Hirakoso
'*
'*
'*--------------------------------------------------------------------------
'*.Copyright(c) 2006,2007,2011 ADVANTEST CORPORATION
'*.http://www.advantest.co.jp
'*--------------------------------------------------------------------------

Const CMD_CONN As String = "1,"
Const CMD_DISCONN As String = "2,"
Const CMD_CONTON As String = "3,"
Const CMD_CONTOFF As String = "4,"
Const CMD_DATA As String = "5,"
Dim repData As String
Dim exitFg As Integer



Private Sub cmdEnd_Click()
Dim i

    'IP address copy.....
    hostA = txtHostA.Text
    hostB = txtHostB.Text
    hostC = txtHostC.Text
    portA = txtPortA.Text
    portB = txtPortB.Text
    portC = txtPortC.Text
    
    If Option5.Value = True Then
        HostMode = 1
    Else
        If Option6.Value = True Then
            HostMode = 2
        Else
            HostMode = 3
        End If
    End If
    
        
    InitSave                                'Back up IP Address

    exitFg = 1
    Debug.Print "Forms", Forms.Count
    For i = 0 To Forms.Count - 1
        Unload Forms(i)
    Next i
    
    SetupLAN = 0

End Sub



Private Sub cmdDisConn_Click()
    Dim ErrRet As Integer

    ErrRet = SendDtFunc("GTL")
    sbrMessage.SimpleText = "Closing..."
    tcpClient.Close
    sbrMessage.SimpleText = "Closed"
        
    cmdConnect.Enabled = True
    cmdConnect.Default = True
    cmdDisConn.Enabled = False
    
    txtHostA.Enabled = True
    txtPortA.Enabled = True
    txtHostA.SetFocus
    
    SetupLAN = 0
    
End Sub



Private Sub cmdConnect_Click()
Dim Sp As String
Dim SendDt As String, ErrRet As Integer
Dim HostData As String, HostPort As String

On Error GoTo ConnectErrProc

    If Option5.Value = True Then
        HostData = txtHostA.Text
        HostPort = txtPortA.Text
    End If
    If Option6.Value = True Then
        HostData = txtHostB.Text
        HostPort = txtPortB.Text
    End If
    If Option7.Value = True Then
        HostData = txtHostC.Text
        HostPort = txtPortC.Text
    End If

    If Trim$(HostData) <> "" And _
      Trim$(HostPort) <> "" Then
    'AvP[Vɐڑv𑗐M܂
        tcpClient.Protocol = sckTCPProtocol
        tcpClient.LocalPort = 0
        tcpClient.RemoteHost = HostData
        tcpClient.RemotePort = HostPort
        tcpClient.Connect
        sbrMessage.SimpleText = "Connecting... ( or NO IP Address: Re-Push Connect-key )"
            
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
        Loop
        tcpClient.GetData Sp
        lstRecv.AddItem tcpClient.RemoteHost & "-->" & Sp
        ErrRet = SendDtFunc("REN")

        cmdTrace.Default = True
        cmdDisConn.Enabled = True
        cmdConnect.Enabled = False
        
        SetupLAN = 1
        
    Else

        MsgBox "Please input the IP Address"
        SetupLAN = 0
        
    End If
    
    Exit Sub
    
ConnectErrProc:

    sbrMessage.SimpleText = "ERROR : Please check IP address"
    
    tcpClient.Close
        
    cmdConnect.Enabled = True
    cmdConnect.Default = True
    cmdDisConn.Enabled = False
    
    
End Sub



Private Sub cmdSend_Click()
Dim SendDt As String, ErrRet As Integer
Dim RcvDt As String
Dim dTimer As Double, iErrFg As Integer


If SetupLAN = 1 Then

    ErrRet = SendDtFunc("REN")              'Remote setting
    If ErrRet <> 0 Then Exit Sub
                                            'SendDt = CMD_DATA + txtSend.Text
    SendDt = txtSend.Text
    ErrRet = SendDtFunc(SendDt)
    If ErrRet <> 0 Then Exit Sub
    
    iErrFg = 0
    dTimer = Timer
    If InStr(SendDt, "?") > 0 Then
'        ErrRet = SendDtFunc(SendDt)
        Do While (tcpClient.BytesReceived = 0)
            DoEvents
            If Timer > dTimer + 10# Then
                iErrFg = 1
                Exit Do
            End If
        Loop
        If iErrFg = 0 Then
            tcpClient.GetData RcvDt
            lstRecv.AddItem tcpClient.RemoteHost & "-->" & RcvDt
        Else
            lstRecv.AddItem tcpClient.RemoteHost & "-->" & "Query error!"
        End If
        lstRecv.ListIndex = Form1.lstRecv.ListCount - 1
   End If
   
Else

    MsgBox "Please open the LAN: Connect button..."

End If


End Sub


Private Sub cmdTrace_Click()
Dim ErrRet As Integer

If SetupLAN = 1 Then

    ErrRet = SendDtFunc("REN")              'Remote setting
    
    If Option1.Value = True Then            'INPUT 1 or 2
        ErrRet = SendDtFunc("ACTCH CH1")
    Else
        ErrRet = SendDtFunc("ACTCH CH2")
    End If
    
    ErrRet = SendDtFunc("CALCA WRITE; AW")  'A Write
        
    Sleep 100                               ' Wait for setting

    DispForm.Show vbModal
    
Else

    MsgBox "Please open the LAN: Connect button..."

End If


End Sub

Private Sub Form_Load()


InitRecall          'Check the Back up address
'------------------------------------------------

txtHostA.Text = hostA
txtHostB.Text = hostB
txtHostC.Text = hostC
txtPortA.Text = portA
txtPortB.Text = portB
txtPortC.Text = portC


If HostMode = 1 Then                'Host?
    Option5.Value = True
    If HostAinput = 1 Then
        Option1.Value = True
    Else
        Option2.Value = True
    End If
Else
    If HostMode = 2 Then
        Option6.Value = True
        If HostBinput = 1 Then
            Option1.Value = True
        Else
            Option2.Value = True
        End If
    Else
        Option7.Value = True
        If HostCinput = 1 Then
            Option1.Value = True
        Else
            Option2.Value = True
        End If
    End If
End If

    
exitFg = 0
SizeValue = 0
DataGetFg = False   'DataǂłȂ
GridType = 0        '
GridDivX = 10       '10
GridDivY = 10       'c10

'DispForm.Show

cmdDisConn.Enabled = False

End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
If exitFg <> 0 Then Exit Sub

MsgBox "Use EXIT button for quit.", vbOKOnly, App.Title
Cancel = -1
End Sub

Private Sub Form_Unload(Cancel As Integer)
End
End Sub

Private Sub Option1_Click()

If Option5.Value = True Then HostAinput = 1
If Option6.Value = True Then HostBinput = 1
If Option7.Value = True Then HostCinput = 1

End Sub

Private Sub Option2_Click()

If Option5.Value = True Then HostAinput = 2
If Option6.Value = True Then HostBinput = 2
If Option7.Value = True Then HostCinput = 2

End Sub

Private Sub Option5_Click()

    If HostAinput = 1 Then
        Option1.Value = True
    Else
        Option2.Value = True
    End If
    
End Sub

Private Sub Option6_Click()

    If HostBinput = 1 Then
        Option1.Value = True
    Else
        Option2.Value = True
    End If

End Sub

Private Sub Option7_Click()

    If HostCinput = 1 Then
        Option1.Value = True
    Else
        Option2.Value = True
    End If

End Sub

Private Sub tcpClient_Close()
'ڑؒf܂
    sbrMessage.SimpleText = "Closed"
    sbrMessage.Refresh
End Sub

Private Sub tcpClient_Connect()
'ڑ܂
Dim Sp As String
Dim SendDt As String, ErrRet As Integer

    sbrMessage.SimpleText = "Connected with " & _
                      tcpClient.RemoteHost & ":" & _
                      tcpClient.RemotePort
    sbrMessage.Refresh
    txtSend.SetFocus
    cmdSend.Enabled = True
    cmdSend.Default = True

'    Do While (tcpClient.BytesReceived = 0)
'        DoEvents
'    Loop
'    tcpClient.GetData Sp
'    lstRecv.AddItem tcpClient.RemoteHost & "-->" & Sp
End Sub

Private Sub tcpClient_ConnectionRequest(ByVal requestID As Long)
Debug.Print "ConnectionReques", requestID

End Sub

Private Sub tcpClient_DataArrival(ByVal bytesTotal As Long)
'f[^͂܂
    Dim strBuf      As String
'AvP[V̑Mf[^擾܂
'    tcpClient.GetData strBuf
'    repData = strBuf
'    lstRecv.AddItem tcpClient.RemoteHost & "-->" & strBuf
'    lstRecv.ListIndex = lstRecv.ListCount - 1
End Sub

Private Sub tcpClient_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
Debug.Print "Error", Number, Description, Source

End Sub

Private Sub tcpClient_SendComplete()
'Debug.Print "SendComplete"

End Sub

Private Sub tcpClient_SendProgress(ByVal bytesSent As Long, ByVal bytesRemaining As Long)
'Debug.Print "SendProgress"

End Sub


Public Sub InitSave()

On Error GoTo ErrProcSave
    
    Form1.sbrMessage.SimpleText = "Save the setting data... done"
    
    Open "C:\Program Files\U3800 LAN_DspTrace\LAN_RMT_Init.dat" For Output As #1
    
        Write #1, hostA; hostB; hostC; portA; portB; portC; HostMode; HostAinput; HostBinput; HostCinput; OfsFreq1; OfsFreq2; OfsFreq3
    
    Close #1
        
    Exit Sub
    
ErrProcSave:
    Close #1
    Form1.sbrMessage.SimpleText = "Save the setting data... Error: No Pass_name"
        
End Sub


Public Sub InitRecall()

Form1.sbrMessage.SimpleText = "Recall setting data... done "

On Error GoTo ErrProcRecall

    Open "C:\Program Files\U3800 LAN_DspTrace\LAN_RMT_Init.dat" For Input As #1
    
        Input #1, hostA, hostB, hostC, portA, portB, portC, HostMode, HostAinput, HostBinput, HostCinput, OfsFreq1, OfsFreq2, OfsFreq3
        
    Close #1

    Exit Sub
    
ErrProcRecall:

    Close #1
    Form1.sbrMessage.SimpleText = "No previous data file found... (Initial setting)"
    ' IP Address setup
    hostA = "192.168.0.1"
    hostB = "192.168.0.2"
    hostC = "192.168.0.3"
    portA = "5025"
    portB = "5025"
    portC = "5025"
    
    HostMode = 1
    
    HostAinput = 1
    HostBinput = 1
    HostCinput = 1

    OfsFreq1 = "0"
    OfsFreq2 = "0"
    OfsFreq3 = "0"
        
End Sub

'--------------------------------------------------------------------------------------------



